####################################
# MH Sample Viewer Ver.1.2
# by ManiHoni
# Copyright 2013 All Rights reserved
# manihoni2008@gmail.com
# http://www.manihoni.net/
####################################

import poser
import wx
import wx.py
import wx.aui
import os

###############
# Please  set Width(=mW) and Height (=mH) of your monitor
mW = 1920
mH = 1200
###############

msv = "MH Sample Viewer Ver.1.2 : "

class Frame1( wx.Frame ):
	def __init__(self, parent):
		
		fW = W+6
		fH = H+26
		if fW >= mW:
			fW = mW
			pW = 0
		else:
			pW = (mW-fW)/2
		if fH >= mH:
			fH = mH
			pH = 0
		else:
			pH = (mH-fH)/2
		wx.Frame.__init__(self, parent, title=msv+imgname, pos=wx.Point(pW,pH), size=(fW, fH), style=wx.CAPTION | wx.CLOSE_BOX | wx.MINIMIZE_BOX | wx.STAY_ON_TOP)
		wx.StaticBitmap(self, -1, img, (0,0), size=(W, H))


imgname = os.path.basename(__file__).replace('.py','.jpg')
imgpath = os.path.join(os.path.dirname(__file__), imgname)

if os.path.exists(imgpath) :

	img = wx.Bitmap(imgpath, wx.BITMAP_TYPE_JPEG)
	W = img.GetWidth()
	H = img.GetHeight()
	
	if W+H > 0:
		man = poser.WxAuiManager()
		root = man.GetManagedWindow()
		frame = Frame1(None)
		frame.Show()
	else:
		print "=================================="
		print "MH Sample Viewer >> \""+imgname+"\" cannot be opened."
		print "MH Sample Viewer >> Please check the condition of \""+imgname+"\". "
		print "=================================="

else:
	print "=================================="
	print "MH Sample Viewer >> \""+imgname+"\" is not found."
	print "MH Sample Viewer >> Please check the name and location of a image file."
	print "=================================="

